close all;

figure
plot(T,MAX,'LineWidth',2);
xlabel('time (sec)','FontSize',18,'FontWeight','bold');
ylabel('J=f(x,y)','FontSize',18,'FontWeight','bold');
title('Output','FontSize',18,'FontWeight','bold');
grid on;  
set(gca,'FontSize',12,'FontWeight','bold'); 
axis([0 20 -0.8 1.2]);
saveas(gcf,'susp_output.eps','psc2');
axis([0 5 -0.8 1.2]);
saveas(gcf,'susp_output_new.eps','psc2');


figure
plot(X,Y,'LineWidth',2);
xlabel('x','FontSize',18,'FontWeight','bold');
ylabel('y','FontSize',18,'FontWeight','bold');
title('Vehicle Trajectory','FontSize',18,'FontWeight','bold');
grid on;  
set(gca,'FontSize',12,'FontWeight','bold'); 
saveas(gcf,'susp_trajectory.eps','psc2');


figure
plot(T,Vx,'LineWidth',2);
xlabel('time (sec)','FontSize',18,'FontWeight','bold');
ylabel('V_x','FontSize',18,'FontWeight','bold');
title('Control Input of X-axis','FontSize',18,'FontWeight','bold');
grid on;  
set(gca,'FontSize',12,'FontWeight','bold'); 
saveas(gcf,'susp_vx.eps','psc2');
axis([0 5 -5 5]);
saveas(gcf,'susp_vx_new.eps','psc2');


figure
plot(T,Vy,'LineWidth',2);
xlabel('time (sec)','FontSize',18,'FontWeight','bold');
ylabel('V_y','FontSize',18,'FontWeight','bold');
title('Control Input of Y-axis','FontSize',18,'FontWeight','bold');
grid on;  
set(gca,'FontSize',12,'FontWeight','bold'); 
saveas(gcf,'susp_vy.eps','psc2');
axis([0 5 -8 6]);
saveas(gcf,'susp_vy_new.eps','psc2');
